<?php

/**
 * CC Multiple Certification Helper
 *
 *
 * @link              http://cog.dog/
 * @since             1.0.0
 * @package           cc_cert_helper
 *
 * @wordpress-plugin
 * Plugin Name:       Creative Commons  Certification Helper
 * Plugin URI:        http://github.com/cogdog/cc-cert-helper
 * Description:       This plugin adds functionality such as navigation and post-processing for GitHub / markkdown source material for sites showing the Creative Commons Certification. It can be used for a "publisher" type site for modifying source content from GitHub, or modifying an HTML form export from a publisher site. 
 * Version:           1.4.0
 * Author:            Alan Levine
 * Author URI:        http://cog.dog/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt

 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define('cc_cert_helper_PLUGIN_VERSION', '1.4');

// Harcoded now, will be turned into an option. If 'yes' will remove first line header tags, adjust image urls, and keep content as markdown on saving posts. Set to 'no' for a site using an export form a publisher site
define('cc_cert_helper_MARKDOWNSOURCE', 'yes');


// -- default style sheet (should be eventually a plugin option)
if ( !function_exists('cc_cert_helper_add_stylesheet') ) {
	function cc_cert_helper_add_stylesheet() {
		wp_enqueue_style( 'cc-cert-helper-style', plugins_url( '/css/cc-cert.css', __FILE__ ), false, cc_cert_helper_PLUGIN_VERSION, 'all' );
	}


	
	add_action('wp_enqueue_scripts', 'cc_cert_helper_add_stylesheet', 90);
}

if ( !function_exists('cc_cert_helper_get_top_parent') ) {
	function cc_cert_helper_get_top_parent ( $page_id ) {
		// the top parent in a chain of pages
		// ----- h/t http://wordpress.stackexchange.com/a/43374/14945
		$ancestors = get_post_ancestors( $page_id ); 

		//$ancestors is an array of post IDs starting with the current post going up the root
		//'Pop' the root ancestor out or returns the current ID if the post has no ancestors.
		$root_id = ( !empty ($ancestors ) ? array_pop( $ancestors ): $page_id);

		return ($root_id);
	}
}


if ( !function_exists('cc_cert_helper_get_navbox') ) {
	function cc_cert_helper_get_navbox ( $cert_title,  $type = 'module', $mod_title = '' ) {  
	// construct sidebar navigation for certification index, modules, and units
	
		if ( $type == 'module') {
	
			$out = '<div id="rbox"><h3>' . $cert_title . ' Modules</h3>';

			// links are the other modules
			$out .= do_shortcode( '[pagelist child_of="parent" depth="1" class="modlist"]');
		
			$out .= '<h3>' . $mod_title . ' Module Units</h3>';
		
			// Add links to units in this module
			$out .=  do_shortcode( '[pagelist child_of="current" depth="1" class="unitlist"]') . '</div>';
		
		} elseif ( $type == 'unit') {

			$out = '<div id="rbox"><h3>' . $cert_title . '</h3>';

			// links are the other modules
			$out .=  do_shortcode( '[pagelist child_of="' . wp_get_post_parent_id($parent_id) . '" depth="1" class="modlist"]');

			// now let's do the unit

			$out .= '<h3>' . $mod_title . '</h3>';
	
			 // links are the other units
			$out .= do_shortcode( '[siblings depth="1"  class="unitlist"]') . '</div>';
		}
	
	
		return $out;

	 }
 }
 
 
if ( !function_exists('cc_cert_helper_stripFirstLine') ) {
	function cc_cert_helper_stripFirstLine( $text ) {
		// removes first line of text from string
		// ----- h/t http://stackoverflow.com/a/7740485/2418186
		return substr( $text, strpos($text, "\n")+1 );
	}
}

if ( !function_exists('cc_cert_helper_get_feedback_form') ) {
	function cc_cert_helper_get_feedback_form ( $pid, $type = '', $gformid = 2 ) {

	/* ----- get code for adding gravity form for feedback (main site only
			 Parameters 
				$pid = the current page id
				$type = "module" or "unit"
				$gformid = gravity form id used
	
	In the future this will be a plugin option to add additional content after the content
																					  ----- */
		// do we have a parent?
		$parent_id = wp_get_post_parent_id( $pid );

		if ( !$parent_id ) {
			// if we do not have a parent, use the current page
			$parent_id =  $pid;
		}

		// get us some post stuff so we can fetch a title
		$parent = get_post( $parent_id );

		// set the certification name
		$certification = ucfirst($parent->post_name);

		if ( $type != '') {
			// add a flag for the gform to indicate this is a module page and to include its title
			$extra_param = '&amp;' . $type  . '=' .  get_the_title();
		}
	
		return '
		<!-- start form for feedback -->
		<div class="entry-content" id="certsuggest">
			<h2>Feedback and Suggestions for ' . get_the_title( $pid ) . '</h2>' . 
			do_shortcode('[gravityforms id="' . $gformid  . '" title="false" ajax="true" field_values="referer='  . get_permalink( $pid ) . '&amp;certification=' . $certification . $extra_param . '"]') . '
		</div>
		<!-- end  form for feedback -->';

	}
}


if ( !function_exists('cc_cert_helper_get_resource_form') ) {
	function cc_cert_helper_get_resource_form ( $pid ) {

		return '
		<!-- start form for feedback -->
		<div class="ccolumn">
			<h2>Add a Resource for ' . get_the_title( $pid ) . '</h2>
			<p>Do you know of a resource or activity that would be good for this unit? Please add it to our collection via our <a href="https://goo.gl/forms/TEm09yXVPUKVF9Mp1" class="button cc small" target="_blank">resource suggestion form</a>
		</div>
		<!-- end  form for feedback -->';
	}
}



/* ----- 

		filter the content on output to add shortcodes for navigation, and add any extra
		content to append after but not muck with the post content                                                    

----- */

if ( !function_exists('cc_cert_helper_content_filter') ) {

	add_filter( 'the_content', 'cc_cert_helper_content_filter', 20 );

	function cc_cert_helper_content_filter( $content ) {

		// doth we have a Page?
		if ( is_page() ) {
		
			global $post;
		
			// look for post meta
			$cc_cert_page_type = get_post_meta( $post->ID, 'CC Cert Page Type', true );			

			if ( $cc_cert_page_type == 'index' )  {

				// top level content pages
				$topnav = do_shortcode('[pagelist child_of="parent" depth="1" class="topnav"]');
				
				// all we need is nav
				$content = $topnav . $content;
				

			} elseif ( $cc_cert_page_type == 'module' )  {
				// page is a module in a certification
				
				$root_id = cc_cert_helper_get_top_parent($post->ID);
				$parent_id = wp_get_post_parent_id( $post->ID );
				
				// build the top menu
				$topnav = do_shortcode('[pagelist child_of = "' . $root_id . '" depth="1" class="topnav"]');

				// display other stuff after the content, here the gravity form
				// this should be a future option as well as a way to include versioning 
				// $footer_content = cc_cert_helper_get_feedback_form( get_the_ID(), 'module');
				
				$footer_content = '';

				// insert short codes for navigation to other modules and below it to the units in this module
				$content = $topnav . cc_cert_helper_get_navbox( get_the_title( $root_id ), 'module', get_the_title( $post->ID )  ) . $content . $footer_content;			

			} elseif (  $cc_cert_page_type == 'unit' )  {
		
				// set up shortcode stuff to add navigation stuff to units, based on parent structure
	
				// display other stuff after the content, here the gravity form
				// this should be a future option as well as a way to include versioning 
				$footer_content = cc_cert_helper_get_resource_form( get_the_ID() );
			
				$parent_id = wp_get_post_parent_id( get_the_ID() ); // this should be the module for this unit

				$grandparent_id = wp_get_post_parent_id( $parent_id ); // this should be the content page id
				
				if ( get_post_ancestors( $grandparent_id ) ) {
					$topnav = do_shortcode('[pagelist child_of="' . wp_get_post_parent_id( $grandparent_id ) . '" depth="1" class="topnav"]') ;
				
					
				} else {
					$topnav = do_shortcode('[pagelist include="' . $grandparent_id . '" number="1" class="topnav"]') ;
				}	
				
				$content = $topnav .  cc_cert_helper_get_navbox( get_the_title( $root_id ), 'unit', get_the_title( $parent_id ) ) . $content . $footer_content;

			} // if $cc_cert_page_type
		
		} // is_page()
	
		// Send back the content, pronto!
		return $content;
	} // function
}	

/* ----- 

		clean markdown content on save to remove the header on the first line,
		adjust local links to *.md  files and to adjust image URLs to fetch from the 
		GH pages version                                                 

----- */



if ( !function_exists('cc_cert_helper_cleaner') ) {

	// only use for sotes where content is markdown
	if (cc_cert_helper_MARKDOWNSOURCE == 'yes' ) add_action( 'save_post_page', 'cc_cert_helper_cleaner' );

	function cc_cert_helper_cleaner( $post_id ) {
	
		// If this is just a revision, keep moving along
		if ( wp_is_post_revision( $post_id ) ) return;

		// look for post meta
		$cc_cert_page_type = get_post_meta( $post_id, 'CC Cert Page Type', true );
		
		// get us some content
		$the_post = get_post( $post_id,  OBJECT, 'edit');
		$content = $the_post->post_content;
		
		// remove first line if it has a header tag
		if ( substr($content, 0, 1) == "#") $content = cc_cert_helper_stripFirstLine( $content );
		
		// replace local links in markdown tp work as sub page links in WP
		$content = str_replace ( '/index.md', '/', $content);
		$content = str_replace ( '.md', '/', $content);
					
		// URLs to GH hosted images, first URLs are the needle, second is replace
		// cant grep for my life 
		// When I grow up tp ne a real plugin, these will be user options.
		$img_url_orig = ['https://github.com/creativecommons/cc-cert-map/blob/master/img/',
						 'https://github.com/creativecommons/cc-cert-map/blob/master/images/',
						 'https://github.com/creativecommons/cc-cert-lin/blob/master/lib/'
						];
							
		$img_url_replace =['https://creativecommons.github.io/cc-cert-map/img/',
		                   'https://creativecommons.github.io/cc-cert-map/images/',
		                   'https://creativecommons.github.io/cc-cert-lib/images/'
		                  ];
		for ($i = 0; $i < count ( $img_url_orig ); $i++ ) {
				// replace all URLs for the repo image with one for GH pages (so we can display)
				$content = str_replace ( $img_url_orig[$i] , $img_url_replace[$i] , $content);
		}
		

		// have we changed anyhing?
		if ( !( $content === $the_post->post_content ) ) {
		
			// yes, let's do some updating
			
			// unhook this function so it doesn't loop infinitely
			remove_action( 'save_post', 'cc_cert_helper_cleaner' );

			// update the post, which calls save_post again
			wp_update_post( array( 'ID' => $post_id, 'post_content' => $content ) );

			// re-hook this function
			add_action( 'save_post', 'cc_cert_helper_cleaner' );
		
		} // $content changed
	} // function
}