<?php
/**
* Template Name: GF Video Gallery


* Custom video gallery based on submissions to a Gravity Form
*/

get_header(); 

// configuration, terribly hard coded now

$gf_id = 1; 		// gravity form ID
$gf_name = 1; 		// field id for name
$gf_video = 2; 		// field id for video url 
$gf_location = 6; 	// field id for geo location
$gf_verified = 5;	// field id for verified

// Use Gravity form APS to get all entry data for active items
$gf_results = GFAPI::get_entries( $gf_id, array(  'status'  => 'active'  ), null, array( 'offset' => 0, 'page_size' => 99999) );

// walk the results to save only ones marked as active
// store in array

// let's randomize!
shuffle ($gf_results); 

foreach ( $gf_results as $item) {
	if ($item[$gf_verified] == "yes") $finds[] = array (
			'name' => $item[$gf_name],
			'url' => $item[$gf_video],
			'loc' => $item[$gf_location]
		);
}


?>


<?php while ( have_posts() ) : the_post(); ?>

    <?php get_template_part( 'template-parts/wrapper', 'top' ); ?>

        <div id="primary" class="content-area">
            <main id="main" class="site-main" role="main">

				<?php get_template_part( 'template-parts/cover', 'post' ); ?>

				 <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="entry-content gallery-text">
						<?php the_content(); ?>

						<hr />
						<p><strong><?php echo count($finds)?></strong> total videos available...</p>
					</div><!-- .entry-content -->
				</article><!-- #post-## -->
<?php endwhile; // End of the loop. ?>


		
		<?php if (count ( $finds ) ) :?>
			
			<div id="posts" class="grid card-2">
			
				<?php foreach ( $finds as $item) {?>
				
					<article class="hentry">
						<header class="entry-header">
							<h1 class="entry-title"><?php echo $item['name']?></h1>
							<h2 class="entry-subtitle"><?php  if  ($item['loc'] ) { echo $item['loc']; } else {  echo '&nbsp';} ?></h2>
						</header>
						 <div class="entry-summary">
						 	<div class="videowrapper">
							<?php echo wp_oembed_get($item['url']);?>
							</div>
						</div>
					</article>
				<?php }?>	
			</div>
					
		<?php else:?>
			<p>Sorry, no videos found.</p>
		<?php endif?>
		

            </main><!-- #main -->
        </div><!-- #primary -->

<?php get_footer();
