<?php

add_filter( 'body_class', 'gf_gallery_body_classes' );

function gf_gallery_body_classes( $classes ) {
	// slugs for possible gallery pages, needed to add extra body class for these pages
	if ( is_page( array( 'gallery', 'what-if' ) ) ) {
		$classes[] = 'gallery_page';
	}

	return $classes;
}

// Enable additional oEmbed for other video sites
add_action( 'init', 'cc_cert_add_oembed_handlers' );

function cc_cert_add_oembed_handlers() {
	// kaltura for warwick
	wp_oembed_add_provider( 'https://warwick.mediaspace.kaltura.com/id/*', 'https://warwick.mediaspace.kaltura.com/oembed' );
}

function is_embed_video ( $url ) {
	// tests if URl is for a youtube or vimeo site to use in lightbox pluging
	// ---- h/t https://gist.github.com/mjangda/1623788

	// valid domain list
	$video_domains = array( 'youtube.com', 'youtu.be', 'vimeo.com', 'www.youtube.com' );
	
	// parse domain
	$domain = parse_url( $url, PHP_URL_HOST );
	
	// Check if we match the domain exactly
	if ( in_array( $domain, $video_domains ) ) return true;
}


function url_is_ok_video ( $url ) {
// Use for gravity form to verify video is from a URL we can autoembed in Wordpress
	$allowed_videos = array(
					'youtube.com',
					'youtu.be',
					'vimeo.com',
					'soundcloud.com',
					'kaltura.com'
	);

	// walk the array til we get a match
	foreach( $allowed_videos as $fragment ) {
  		if  (strpos( $url, $fragment ) !== false ) {
			return ( true );
		}
	}	
	
	// no matches, the URL is not for an allowable video
	return ( false );
}

function get_top_parent ( $page_id ) {
	// the top parent in a chain of pages
	// ----- h/t http://wordpress.stackexchange.com/a/43374/14945
	$ancestors = get_post_ancestors( $page_id ); 

	//$ancestors is an array of post IDs starting with the current post going up the root
	//'Pop' the root ancestor out or returns the current ID if the post has no ancestors.
	$root_id = ( !empty ($ancestors ) ? array_pop( $ancestors ): $page_id);

	return ($root_id);
}


function get_cc_cert_navbox ( $title = 'Navigation',  $type = 'module' ) {  
// construct sidebat navigation for certification index, modules, and units
 	
 	if ( $type == 'module') {
 	
		$out = '<div id="rbox"><h3>' . $title . '</h3>';

		// parent is the certification, get id so we can get link
		$parent_id = wp_get_post_parent_id( get_the_ID() );

		// links are the other modules
		$out .= do_shortcode( '[pagelist child_of="parent" depth="1"]') . '</div>';

 		
 	} elseif ( $type == 'unit') {

		// parent is a module, first build it's navigation
		$parent_id = wp_get_post_parent_id( get_the_ID() );

		// certification title is the grandparent!
		$cert_title = get_the_title( wp_get_post_parent_id( $parent_id ) );

		$out = '<div id="rbox"><h3>' . $cert_title . '</h3>';

		// links are the other modules
		$out .=  do_shortcode( '[pagelist child_of="' . wp_get_post_parent_id($parent_id) . '" depth="1"]');

		// now let's do the unit

		$out .= '<h3>' . $title . '</h3>';
	
		 // links are the other units
		$out .= do_shortcode( '[siblings depth="1"]') . '</div>';

 	} else {
 	
 		$out = do_shortcode( '[subpages]');
 	}
 	
 	
 	return $out;

 }
 
/* ----- change content on output as needed                                      ----- */  

function stripFirstLine( $text ) {
	// removes first line of text from string
	// ----- h/t http://stackoverflow.com/a/7740485/2418186
	return substr( $text, strpos($text, "\n")+1 );
}


add_filter( 'the_content', 'cc_cert_content_filter', 20 );

function cc_cert_content_filter( $content ) {

	if ( is_page_template( 'page-cert.php' ) ) {
		// page for all certifications if more than one
	
		// replace local links in markdown tp work as sub page links in WP
		$content = str_replace ( '.md', '/', $content);
	
		// replace all URLs for the repo image with one for GH pages (so we can link)
		$content = str_replace ( 'https://github.com/creativecommons/cc-cert-map/blob/master/img/' , 'https://creativecommons.github.io/cc-cert-map/img/' , $content);
		
		$content = do_shortcode('[siblings depth="1" class="topnav"]') . $content;
	
   } elseif ( is_page_template( 'page-module.php' ) ) {
   		// page is a module in a certification

        // remove first line that has # Header)
		$content = stripFirstLine( $content );
		
		// replace local links in markdown tp work as sub page links in WP
		$content = str_replace ( '.md', '/', $content);

		
		// replace all URLs for the repo image with one for GH pages (so we can link)
		$content = str_replace ( 'https://github.com/creativecommons/cc-cert-map/blob/master/img/' , 'https://creativecommons.github.io/cc-cert-map/img/' , $content);
		
		// set up shortcode stuff to prefix content, based on parent structure
		$parent_id = wp_get_post_parent_id( get_the_ID() ); // this should be the module for this unit
		
		
		// insert short codes
		$content = do_shortcode('[pagelist child_of="' . get_top_parent( get_the_ID() )  . '" depth="1" class="topnav"]') . get_cc_cert_navbox( get_the_title( $parent_id ), 'module' ) . $content;
				
	} elseif ( is_page_template( 'page-unit.php' ) ) {
		        
		// remove first line that has # Header)
		$content = stripFirstLine( $content );
		
		// replace all URLs for the repo image with one for GH pages (so we can link)
		$content = str_replace ( 'https://github.com/creativecommons/cc-cert-map/blob/master/img/' , 'https://creativecommons.github.io/cc-cert-map/img/' , $content);
		
		// set up shortcode stuff to prefix content, based on parent structure
		$parent_id = wp_get_post_parent_id( get_the_ID() ); // this should be the module for this unit
		
		$grandparent_id = wp_get_post_parent_id($parent_id); // this should be the certification this belongs to
		
		// insert short codes
		$content = 
			do_shortcode('[pagelist child_of="' . wp_get_post_parent_id( $grandparent_id ) . '" depth="1" class="topnav"]') 
			.  get_cc_cert_navbox( get_the_title( $parent_id ), 'unit') . $content;
	
	}
	
    // Send back the content, pronto!
    return $content;
}



/* -----  Tie our validation function to the 'gform_validation' hook              ----- */ 
add_filter( 'gform_validation_1', 'validate_whatif' );


/* -----  Form Validation... ACTIVATE                                             ----- */

function validate_whatif( $validation_result ) {

// h/t https://www.gravityhelp.com/documentation/article/using-the-gravity-forms-gform-validation-hook/

    // Get the form object from the validation result
    $form = $validation_result['form'];

    // Loop through the form fields
    foreach( $form['fields'] as &$field ) {
        
        // If the field does not have our designated CSS class, skip it
        if ( strpos( $field->cssClass, 'validate-it' ) === false ) {
            continue;
        }  
        
        // Get the submitted value from the $_POST
        $field_value = rgpost( "input_{$field['id']}" );  
        
        // check the URL for the field (we are looking for the video url field
        $is_valid = url_is_ok_video( $field_value );
        
        // If the urk is valid we don't need to do anything, skip it
        if ( $is_valid ) {
            continue;
        }
        
        // The field failed validation, so first we'll need to fail the validation for the entire form
        $validation_result['is_valid'] = false;
        
        // Next we'll mark the specific field that failed and add a custom validation message
        $field->failed_validation = true;
        $field->validation_message = 'The URL you entered is not from an accepted video service. Please try again';
    }
    
    // Assign our modified $form object back to the validation result
   	 $validation_result['form'] = $form;
    
    // Return the validation result
    return $validation_result;
    
}


 
/* ----- create cookie to remember user name and email for gravity form collecting resources ----- */ 
add_action("gform_pre_submission_2", "cookify_gf_form");
 
 
function cookify_gf_form($form_meta) {
	$saveVars = array("name", "email");
	
    foreach($form_meta["fields"] as $field) {
		if (in_array($field["inputName"], $saveVars)) {
			setcookie("gf_".$field["inputName"], $_POST["input_" . $field["id"]], time() + 31536000, COOKIEPATH, COOKIE_DOMAIN, false, true);
		}
	}
}

add_filter("gform_field_value_name", "populate_name");

function populate_name() {
	if (isset($_COOKIE["gf_name"]))  return $_COOKIE["gf_name"];
}

add_filter("gform_field_value_email", "populate_email");

function populate_email() {
	if (isset($_COOKIE["gf_email"])) return $_COOKIE["gf_email"];
}
 
?>
